:: 20XX 4.0 created by Achilles
:: xdelta program created by Josh Macdonald
:: This script and xdelta file created by DRGN.
:: Script version 2.1

@echo off

set version=04
set betaMD5=8b a4 4d fc 2c ee dc 4d dc e6 36 d9 c9 15 93 89

set originalISO=%~1




	:: First, ensure a file was provided to the script.

if NOT "%originalISO%"=="" goto :sourceProvided

echo.
echo  To use this, drag-and-drop your Vanilla 1.02 ISO onto the batch file.
echo.
echo  (That is, the actual file icon in the folder, not this window.)
echo. 
echo  Press any key to exit. . . && pause > nul

goto eof



	:: Confirm that the CertUtil utility (to perform the hash check) exists on the system.

:sourceProvided

where CertUtil >nul 2>nul

if %ERRORLEVEL%==0 goto :validateHash

set certUtilExists=false

echo.
echo  The hash checking utility (CertUtil) was not found installed on your system.
echo  You can still skip the hash check and force the build anyway, if you'd like,
echo  by pressing any key. (Or click the window's close button to cancel.)

pause > nul
goto :buildISO



	:: Verify that the given file is a vanilla 1.02 copy of SSBM.

:validateHash

set certUtilExists=true

echo.
echo  Verifying that the given file is a vanilla v1.02 copy of SSBM.
echo.
echo        This will take a few moments....

for /F "skip=1 delims=*" %%i in ('CertUtil -hashfile "%originalISO%" MD5') do (
    if "%%i"=="0e 63 d4 22 3b 01 d9 ab a5 96 25 9d c1 55 a1 74" goto :validISO
)

echo.
echo  The file provided doesn't appear to be a vanilla 1.02 copy of the game.
echo  You can ignore this and build the new ISO anyway, but there's a fairly
echo  good chance you'll run into problems.
echo.
set /p continue=- Would you like to build a new ISO anyway? (y/n): 

if %continue%==n goto eof
if %continue%==no goto eof
goto :buildISO



	:: The ISO has been verified, or the user has chosen to proceed anyway.

:validISO

echo. && echo.
echo        The ISO has been verified!

:buildISO

echo.
echo  Constructing 20XX 4.0 Beta%version%. Please stand by....

cd /d %~dp0

xdelta3-x86_64-3.0.10.exe -d -s "%originalISO%" "20XX 4.0 Beta%version% xdelta patch.xdelta" "20XX 4.0 Beta%version%.iso"

echo. && echo.
echo        Construction complete!



	:: If the hash checking utility is available, and the build was not forced, 
	:: offer to generate a hash of the new 20XX build. 
	:: Display it and also output it to a txt file.

if %certUtilExists%==true if NOT defined continue goto :getBetaHash

echo.
echo  Press any key to exit. . .
pause > nul
goto eof

:getBetaHash

echo.
set /p getHash=- Would you like to check the hash of your new 20XX copy? (y/n): 

if %getHash%==n goto eof
if %getHash%==no goto eof

echo.
echo  Generating MD5 hash....

for /F "skip=1 delims=*" %%i in ('CertUtil -hashfile "20XX 4.0 Beta%version%.iso" MD5') do if not defined hash set hash=%%i

echo. && echo.
echo        Correct MD5 hash: %betaMD5%
echo  Your 20XX ISO MD5 hash: %hash%

if "%hash%"=="%betaMD5%" echo. && echo        Hashes match; ISO verified!

echo %hash% > "Your 20XX 4.0 Beta%version% MD5 hash.txt"

echo.
echo  Press any key to exit. . . && pause > nul